﻿using System;
using System.Collections.Generic;
using System.Web.UI;
using Microsoft.Reporting.WebForms;
using VeteransAffairs.Registries.Business.Utilities;

public partial class ReportFollowupReferral : BasePage
{
    private const string REPORT_NAME = "FollowupReferralReport";

    private static IReadOnlyList<string> _navigationSources = new List<string>
    {
        "/Reporting.aspx",
        "/ReportReferral.aspx",
        "/ReportReferralBySite.aspx",
        "/ReportDoDFragment.aspx",
        "/ReportUniqueIndividuals.aspx",
        "/PatientWorkflows.aspx"
    };
    
    private readonly List<ReportParameter> _reportParameters;

    private bool _batchReport = false;

    public string ServerReportParameters { get; set; }

    public ReportFollowupReferral()
    {
        _reportParameters = new List<ReportParameter>();

        NavigationSources = _navigationSources;
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!AccessAllowed())
        {
            Response.Redirect("ErrorPage.aspx?id=100");
        }

        if (!Page.IsPostBack)
        {
            Session["batchReport"] = SessionItemFactory.Create(_batchReport.ToString());
            Session["EFRBatchPrintOptions"] = SessionItemFactory.Create(Helpers.getCrsSetting("EFRBatchPrintOptions"));
            Session["EFRIndividualPrintOptions"] = SessionItemFactory.Create(Helpers.getCrsSetting("EFRIndividualPrintOptions"));

            ClientScript.RegisterStartupScript(GetType(), "LoadPrintOptions", "window.onload=loadReportPrintOptions();");

            SetReferringPage();
        }
    }

    private void SetReportPath()
    {
        ReportViewerReport.ServerReport.ReportPath = REPORT_NAME;

        var config = RegistriesConfigurations.GetConfig();

        ReportViewerReport.ServerReport.ReportServerUrl = new Uri(Helpers.GetConfigEntry("ReportingServer"));

        if (ReportViewerReport.ServerReport.ReportPath.IndexOf(
                Helpers.GetConfigEntry("BaseReportPath"), 0) == -1)
        {
            ReportViewerReport.ServerReport.ReportPath =
                Helpers.GetConfigEntry("BaseReportPath") + ReportViewerReport.ServerReport.ReportPath;
        }
    }

    protected void ButtonRunReportClick(object sender, EventArgs e)
    {
        ReportViewerReport.Reset();
        SetReportPath();
        SetReportParameters();

        ReportViewerReport.ProcessingMode = ProcessingMode.Remote;
        ReportViewerReport.Visible = true;
        ReportViewerReport.ServerReport.Refresh();
    }

    private void SetReportParameters()
    {
        if (TextBoxDateFrom.Text != "")
        {
            ReportParameter reportParamDate = new ReportParameter("fromDate", TextBoxDateFrom.Text);
            _reportParameters.Add(reportParamDate);

            ReportParameter reportParamHeaderText = new ReportParameter("headerText", "Triage Date From: " + TextBoxDateFrom.Text);
            _reportParameters.Add(reportParamHeaderText);
        }
        
        ReportViewerReport.ServerReport.SetParameters(_reportParameters);
    }

  protected void Cancel_Click(object sender, EventArgs e)
    {
        RedirectToReferringPage();
    }

    private bool AccessAllowed()
    {
        return true;
    }
    public override string TopMenuName()
    {
        return "Reporting";
    }

    public override string MenuItemName()
    {
        return "Followup Referral Report";
    }

    public override string AppObjectCode()
    {
        return "EFR_FOLLOWUP_REFERRAL_REPORT";
    }

}
